;String and register functions:
;StrToIntW
;strlen
;strlenW
;strcpyAW
;denter
;dleave
;StringW2A
;StringA2W
;RoundSize
;SetZeroString


UsedSizeBydEnter equ 0x14

;---------------------------------
;----Function StrToIntW-----------
;----Arguments--------------------
;-------0x4 Unicode string--------
;---------------------------------
;----ReturnValue------------------
;-------String -> Dword-----------
;---------------------------------

if used StrToIntW
	StrToIntW:
	call denter
	mov edi,dword [ebp+0x8]

	mov ebx,0xA
	cmp word [edi],'0'
	jne StartStrToIntW
	cmp word [edi+0x2],'x'
	jne StartStrToIntW

	mov ebx,0x10
	add edi,0x4

	StartStrToIntW:
	; edi = buffer, ebx = base
	xor	eax,eax
	xor	edx,edx
	.loop:
	mov	dx,word [edi]
	test	dx,dx
	jz	.endx
	imul	eax,ebx
	sub	dx,'0'
	cmp	dx,9
	jle	.ok
	sub	dx,7
	.ok:
	add	eax,edx
	add	edi,2
	jmp	.loop
	.endx:
	call dleave
	ret 0x4
end if

;---------------------------------
;----Function strlen--------------
;----Arguments--------------------
;-------0x4 Assci String----------
;---------------------------------
;----ReturnValue------------------
;-------Size in bytes-------------
;---------------------------------

if used strlen
	strlen:
	call denter
	xor eax,eax
	cmp dword [ebp+0x8] ,0
	je NoStr
	
	mov esi,dword [ebp+0x8]
	
	xor edx,edx
	dec edx
	
	FindLength:
	inc edx
	lodsb
	test al,al
	jnz FindLength

	mov eax,edx

	NoStr:
	call dleave
	ret 0x4
end if

;---------------------------------
;----Function strlenW-------------
;----Arguments--------------------
;-------0x4 Unicode String--------
;---------------------------------
;----ReturnValue------------------
;-------Size in bytes-------------
;---------------------------------

if used strlenW
	strlenW:
	call denter
	xor eax,eax

	mov esi,dword [ebp+0x8]
	mov esi,dword [ebp+0x8]
	test esi,esi
	jz NoStrW
	
	xor edx,edx
	sub edx,2
	
	FindLengthW:
	add edx,2
	lodsw
	test ax,ax
	jnz FindLengthW

	mov eax,edx

	NoStrW:
	call dleave
	ret 0x4
end if

;---------------------------------
;----Function strcpyAW------------
;----Arguments--------------------
;-------0x4 Assci string----------
;-------0x8 Unicode string--------
;---------------------------------
;----ReturnValue------------------
;-------No return value-----------
;---------------------------------

if used strcpyAW
	strcpyAW:
	call denter
	
	mov edi,dword [ebp+0x8]
	mov esi,dword [ebp+0xC]
	cld
	xor ax,ax

	StartCpy:
	lodsb
	stosw
	test al,al
	jnz StartCpy

	call dleave
	ret 0x8
end if

;---------------------------------
;----Function denter--------------
;----Arguments--------------------
;-------No arguments--------------
;---------------------------------
;----Saves the registers----------
;---------------------------------
;----ReturnValue------------------
;-------No return value-----------
;---------------------------------

if used denter
	denter:
	pop eax
	push edi
	push esi
	push ebx
	push edx
	push ecx
	push ebp

	mov ebp,esp
	add ebp,0x14
	jmp eax
end if

;---------------------------------
;----Function dleave--------------
;----Arguments--------------------
;-------No arguments--------------
;---------------------------------
;----Restores the registers-------
;---------------------------------
;----ReturnValue------------------
;-------No return value-----------
;---------------------------------

if used dleave
	dleave:
	pop ecx
	mov esp,ebp
	sub esp,0x14
	push ecx
	add esp,0x4
	pop ebp
	pop ecx
	pop edx
	pop ebx
	pop esi
	pop edi
	jmp dword [esp-0x1C]
end if

;---------------------------------
;----Function StringW2A-----------
;----Arguments--------------------
;-------0x4 Unicode string--------
;---------------------------------
;----ReturnValue------------------
;-------Assci string--------------
;---------------------------------

if used StringW2A
	StringW2A:
	call denter

	mov eax,dword [ebp+0x8]
	test eax,eax
	jz EndStringW2A

	push eax
	call strlenW
	shr eax,1
	add eax,0x10
	push eax   ;ccbuff

	push eax
	call GetMemLocation

	pop ecx ;cbuff
	push eax

	push 0
	push 0
	push ecx
	push eax
	push -1
	push dword [ebp+0x8]
	push 0;0x40;WC_DEFAULTCHAR
	push 0;CP_ACP
	call [WideCharToMultiByte]

	;push dword [ebp+0x8]
	;push eax
	;call strcpyWA

	pop eax

	EndStringW2A:
	call dleave
	ret 0x4

end if

;---------------------------------
;----Function StringA2W-----------
;----Arguments--------------------
;-------0x4 Assci string----------
;---------------------------------
;----ReturnValue------------------
;-------Unicode string------------
;---------------------------------

if used StringA2W
	StringA2W:
	call denter

	mov eax,dword [ebp+0x8]
	test eax,eax
	jz EndStringA2W

	push eax
	call strlen
	shl eax,1
	add eax,0x10

	push eax
	call GetMemLocation

	push eax

	push dword [ebp+0x8]
	push eax
	call strcpyAW

	pop eax

	EndStringA2W:
	call dleave
	ret 0x4

end if

;---------------------------------
;----Function RoundSize-----------
;----Arguments--------------------
;-------0x4 Size------------------
;---------------------------------
;----ReturnValue------------------
;-------Size rounup by 4----------
;---------------------------------

if used RoundSize
	RoundSize:
	call denter

	mov eax,dword [ebp+0x8]
	mov ebx,4

	xor edx,edx
	div ebx 	;EAX\EBX=EAX:EDX

	mov eax,dword [ebp+0x8]
	test edx,edx
	jz EndRoundSize

	mov ecx,4
	sub ecx,edx
	add eax,ecx

	EndRoundSize:
	call dleave
	ret 0x4
end if

;---------------------------------
;----Function SetZeroString-------
;----Arguments--------------------
;-------0x4 String----------------
;-------0x8 Size------------------
;---------------------------------
;----ReturnValue------------------
;-------No return value-----------
;---------------------------------

if used SetZeroString
	SetZeroString:
	call denter
	
	mov edi,dword [ebp+0x8]
	mov edx,dword [ebp+0xC]
	
	SetZero:
	mov al,0
	stosb
	
	dec edx
	cmp edx,0
	jne SetZero
	
	call dleave
	ret 0x8
end if